**************************************************************************
* DO FILE: DYNAMIC MODEL OF THE INVALID VOTE	
* Author: Mollie J. Cohen
* mollie.cohen@gmail.com
* last edited: 3/27/18
* this do file replicates analyses in paper body and appendices
* variable explanations, data sources are detailed in Appendix Table A1
**************************************************************************

*load XNATL DATA FILE

*Figure 1
graph box invalid, over(pais)

*Table 1: levels
reg linvalid efn2  year , vce(cluster pais)
outreg2 using linvalid.doc, dec(2) replace
reg linvalid efn2 efnpct2 year , vce(cluster pais)
outreg2 using linvalid.doc, dec(2) append
reg linvalid  efn2 efnpct2  nmargvic incumbent concur newsecondrd fhdem lngdp lurban llit compvote year i.pais, vce(cluster pais)
outreg2 using linvalid.doc, dec(2) append
reg linvalid  efn2 efnpct2  cnmargvic incumbent concur newsecondrd cfhdem diffgdp lurban llit compvote year i.pais, vce(cluster pais)
outreg2 using linvalid.doc, dec(2) append

*xtgls models for appendix table A2
xtgls linvalid efn2 year, corr(psar1) force panels(h)
outreg2 using xtinvalid.doc, dec(2) replace
xtgls linvalid efn2 efnpct2 year, corr(psar1) force panels(h)
outreg2 using xtinvalid.doc, dec(2) append
xtgls linvalid  efn2 efnpct2  nmargvic incumbent concur newsecondrd fhdem lngdp lurban llit compvote year, corr(psar1) force panels(h)
outreg2 using xtinvalid.doc, dec(2) append
xtgls linvalid  efn2 efnpct2  nmargvic incumbent concur newsecondrd fhdem lngdp lurban llit compvote year i.pais, corr(psar1) force panels(h)
outreg2 using xtinvalid.doc, dec(2) append
xtgls linvalid  efn2 efnpct2  cnmargvic incumbent concur newsecondrd cfhdem diffgdp lurban llit compvote year i.pais, corr(psar1) force panels(h)
outreg2 using xtinvalid.doc, dec(2) append

*Appendix table A3
xtpcse linvalid efn2 year, corr(psar1) hetonly
outreg2 using xtpcseinvalid.doc, dec(2) replace
xtpcse linvalid efn2 efnpct2 year, corr(psar1) hetonly
outreg2 using xtpcseinvalid.doc, dec(2) append
xtpcse linvalid  efn2 efnpct2  nmargvic incumbent concur newsecondrd fhdem lngdp lurban llit compvote year, corr(psar1) hetonly
outreg2 using xtpcseinvalid.doc, dec(2) append
xtpcse linvalid  efn2 efnpct2  nmargvic incumbent concur newsecondrd fhdem lngdp lurban llit compvote year i.pais, corr(psar1) hetonly
outreg2 using xtpcseinvalid.doc, dec(2) append
xtpcse linvalid  efn2 efnpct2  cnmargvic incumbent concur newsecondrd cfhdem diffgdp lurban llit compvote year i.pais, corr(psar1) hetonly
outreg2 using xtpcseinvalid.doc, dec(2) append

*Appendix table A4
reg diffinvalid efn2  year , vce(cluster pais)
outreg2 using dinvalid.doc, dec(2) replace
reg diffinvalid efn2 efnpct2 year , vce(cluster pais)
outreg2 using dinvalid.doc, dec(2) append
reg diffinvalid  efn2 efnpct2  nmargvic incumbent concur newsecondrd fhdem lngdp lurban llit compvote year, vce(cluster pais)
outreg2 using dinvalid.doc, dec(2) append
reg diffinvalid  efn2 efnpct2  nmargvic incumbent concur newsecondrd fhdem lngdp lurban llit compvote year i.pais, vce(cluster pais)
outreg2 using dinvalid.doc, dec(2) append
reg diffinvalid  efn2 efnpct2  cnmargvic incumbent concur newsecondrd cfhdem diffgdp lurban llit compvote year i.pais, vce(cluster pais)
outreg2 using dinvalid.doc, dec(2) append

*Appendix table A5
xtpcse diffinvalid efn2 year, corr(psar1) hetonly
outreg2 using xtpcsedinvalid.doc, dec(2) replace
xtpcse diffinvalid efn2 efnpct2 year, corr(psar1) hetonly
outreg2 using xtpcsedinvalid.doc, dec(2) append
xtpcse diffinvalid  efn2 efnpct2  nmargvic incumbent concur newsecondrd fhdem lngdp lurban llit compvote year, corr(psar1) hetonly
outreg2 using xtpcsedinvalid.doc, dec(2) append
xtpcse diffinvalid  efn2 efnpct2  nmargvic incumbent concur newsecondrd fhdem lngdp lurban llit compvote year i.pais, corr(psar1) hetonly
outreg2 using xtpcsedinvalid.doc, dec(2) append
xtpcse diffinvalid  efn2 efnpct2  cnmargvic incumbent concur newsecondrd cfhdem diffgdp lurban llit compvote year i.pais, corr(psar1) hetonly
outreg2 using xtpcsedinvalid.doc, dec(2) append


*nonlinearlity depends on the measure - appendix table A6
reg invalid c.ncand2##c.ncand2 ncandpct2 compvote year, vce(cluster pais) 
margins, at(c.ncand2=(2(1)22))
outreg2 using noninear.doc, dec(2) replace
reg invalid c.ncand2_new##c.ncand2_new cncand2p compvote year, vce(cluster pais) 
outreg2 using noninear.doc, dec(2) append
reg invalid c.ncand1##c.ncand1 cncand1p compvote year , vce(cluster pais) 
outreg2 using noninear.doc, dec(2) append
reg invalid c.ncand05##c.ncand05 cncand05p compvote year , vce(cluster pais) 
outreg2 using noninear.doc, dec(2) append
reg invalid c.efn2##c.efn2 efnpct2 compvote year , vce(cluster pais) 
outreg2 using noninear.doc, dec(2) append
reg invalid c.lnncand##c.lnncand clncand compvote year , vce(cluster pais) 
margins, at(c.lnncand=(1.1(.2)3.5))
marginsplot, scheme(s1mono)
outreg2 using noninear.doc, dec(2) append

*figure A1
graph combine "C:\Users\Appendix A3_p1.gph"  "C:\Users\Appendix A3_p2.gph" "C:\Users\Appendix A3_p3.gph" "C:\Users\Appendix A3_p4.gph" "C:\Users\Appendix A3_p5.gph" "C:\Users\Appendix A3_p6.gph", col(3) scheme(s1mono) 


*Additional Control Variables (Table A7)
reg invalid  efn2 efnpct2  cnmargvic incumbent concur newsecondrd cfhdem v2psplats diffgdp lurban llit compvote year, vce(cluster pais)
outreg2 using controls.doc, dec(2) replace
reg invalid  efn2 efnpct2  cnmargvic incumbent concur newsecondrd cfhdem v2psplats diffgdp lurban llit compvote year i.pais, vce(cluster pais)
outreg2 using controls.doc, dec(2) append
reg invalid  efn2 efnpct2  cnmargvic incumbent concur newsecondrd cfhdem polariz diffgdp lurban llit compvote year, vce(cluster pais)
outreg2 using controls.doc, dec(2) append
reg invalid  efn2 efnpct2  cnmargvic incumbent concur newsecondrd cfhdem polariz diffgdp lurban llit compvote year i.pais, vce(cluster pais)
outreg2 using controls.doc, dec(2) append
reg invalid  efn2 efnpct2  cnmargvic incumbent concur newsecondrd cfhdem diffpolar diffgdp lurban llit compvote year, vce(cluster pais)
outreg2 using controls.doc, dec(2) append
reg invalid  efn2 efnpct2  cnmargvic incumbent concur newsecondrd cfhdem diffpolar diffgdp lurban llit compvote year i.pais, vce(cluster pais)
outreg2 using controls.doc, dec(2) append
reg invalid  efn2 efnpct2  cnmargvic incumbent concur newsecondrd cfhdem nullmovenew v2psplats diffgdp lurban llit compvote year, vce(cluster pais)
outreg2 using controls.doc, dec(2) append
reg invalid  efn2 efnpct2  cnmargvic incumbent concur newsecondrd cfhdem nullmovenew v2psplats diffgdp lurban llit compvote year i.pais, vce(cluster pais)
outreg2 using controls.doc, dec(2) append


*Figures A2A and A2B

*generating indicator variables for positive versus other change in effective number of candidates
gen cefnpos=.
replace cefnpos=0 if efnpct2<0
replace cefnpos=1 if efnpct2>0 & efnpct2!=.

*more conservative mesure - 3% change in candidates to be counted as positive or negative
gen cefnpos2=.
replace cefnpos2=0 if efnpct2<-.03
replace cefnpos2=1 if efnpct2>.03 & efnpct2!=.

*A2A
reg linvalid  c.efn2##i.cefnpos nmargvic concur incumbent lngdp lurban llit compvote year i.pais, vce(cluster pais)
margins i.cefnpos, at(c.efn2=(2(.5)7)) l(85)
marginsplot

*A2B
reg linvalid c.efn2##i.cefnpos2 nmargvic concur incumbent lngdp lurban llit compvote year i.pais, vce(cluster pais)
margins i.cefnpos2, at(c.efn2=(2(.5)7)) l(85)
marginsplot

*********************************************************************************
* Replication using change in invalid vote in Peru
* Load Peru Prov data

tsset prov2 year

*Table 4
reg diffinvalid100 efn2 efnpct year, vce(cluster rgn2)
outreg2 using perunew.doc, dec(2) replace
reg diffinvalid100 efn2 efnpct margvic incumbent participacion urbanpct femanalf lnpop year, vce(cluster rgn2)
outreg2 using perunew.doc, dec(2) append
reg diffinvalid100 efn2 efnpct margvic cmargvic incumbent participacion urbanpct femanalf lnpop year, vce(cluster rgn2)
outreg2 using perunew.doc, dec(2) append

*robustness checks: levels
reg invalid100 efn2 efnpct year, vce(cluster rgn2)
outreg2 using perunewl.doc, dec(2) replace
reg invalid100 efn2 efnpct margvic incumbent participacion urbanpct femanalf lnpop year, vce(cluster rgn2)
outreg2 using perunewl.doc, dec(2) append
reg invalid100 efn2 efnpct margvic cnmargvic incumbent participacion urbanpct femanalf lnpop year, vce(cluster rgn2)
outreg2 using perunewl.doc, dec(2) append


* robustness checks, no FE
reg diffinvalid100   efn2 efnpct margvic incumbent participacion urbanpct femanalf lnpop year
outreg2 using diffinvalidper2.doc, dec(2) replace
reg diffinvalid100   efn2 efnpct margvic incumbent participacion urbanpct femanalf lnpop year, vce(cluster rgn2)
outreg2 using diffinvalidper2.doc, dec(2) append
rreg diffinvalid100  efn2 efnpct margvic incumbent participacion urbanpct femanalf lnpop year
outreg2 using diffinvalidper2.doc, dec(2) append
xtpcse diffinvalid100   efn2 efnpct margvic incumbent participacion urbanpct femanalf lnpop year, hetonly
outreg2 using diffinvalidper2.doc, dec(2) append
xtgls diffinvalid100   efn2 efnpct margvic incumbent participacion urbanpct femanalf lnpop year
outreg2 using diffinvalidper2.doc, dec(2) append


* full dynamis
reg diffinvalid100   efn2 efnpct margvic cmargvic incumbent participacion urbanpct femanalf lnpop year i.rgn2
outreg2 using diffinvalidper2.doc, dec(2) replace
reg diffinvalid100   efn2 efnpct margvic cmargvic incumbent participacion urbanpct femanalf lnpop year i.rgn2, vce(cluster rgn2)
outreg2 using diffinvalidper2.doc, dec(2) append
rreg diffinvalid100  efn2 efnpct margvic cmargvic incumbent participacion urbanpct femanalf lnpop year i.rgn2
outreg2 using diffinvalidper2.doc, dec(2) append
xtpcse diffinvalid100   efn2 efnpct margvic cmargvic incumbent participacion urbanpct femanalf lnpop year i.rgn2, hetonly
outreg2 using diffinvalidper2.doc, dec(2) append
xtgls diffinvalid100   efn2 efnpct margvic cmargvic incumbent participacion urbanpct femanalf lnpop year
outreg2 using diffinvalidper2.doc, dec(2) append
